<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container px-6 mx-auto">
        <div class="flex justify-between items-center my-6">
            <h2 class="text-2xl font-semibold text-gray-700">KYC Verification</h2>
            <div class="flex space-x-3">
                <select id="status-filter" class="border border-gray-300 rounded-lg shadow-sm focus:ring-purple-500 focus:border-purple-500">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="approved" <?php echo e(request('status') === 'approved' ? 'selected' : ''); ?>>Approved</option>
                    <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
        </div>

        
        <?php if (isset($component)) { $__componentOriginal6912374916afbfe53350098c2f0b0678 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6912374916afbfe53350098c2f0b0678 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.session-status','data' => ['class' => 'mb-4','status' => session('status')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $attributes = $__attributesOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__attributesOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $component = $__componentOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__componentOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>

        
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full whitespace-no-wrap">
                <thead>
                    <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase bg-gray-50 border-b">
                        <th class="px-4 py-3">User Info</th>
                        <th class="px-4 py-3">Documents</th>
                        <th class="px-4 py-3">Status</th>
                        <th class="px-4 py-3">Submitted Date</th>
                        <th class="px-4 py-3">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y">
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="text-gray-700">
                            <td class="px-4 py-3">
                                <div class="flex items-center">
                                    <div class="mr-3 flex-shrink-0">
                                        <div class="h-10 w-10 rounded-full bg-purple-100 flex items-center justify-center">
                                            <span class="text-lg font-medium text-purple-600">
                                                <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                            </span>
                                        </div>
                                    </div>
                                    <div>
                                        <p class="font-semibold"><?php echo e($user->name); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo e($user->email); ?></p>
                                        <p class="text-xs text-gray-500">ID: <?php echo e($user->uuid); ?></p>
                                    </div>
                                </div>
                            </td>
                          <td class="px-4 py-3">
    <div class="flex flex-col space-y-2">
        <?php if($user->front_id): ?>
            <button type="button" 
                    onclick="openImageModal('<?php echo e(asset('public/' . $user->front_id)); ?>')"
                    class="text-sm text-blue-600 hover:text-blue-800 flex items-center">
                <i class="ri-image-line mr-1"></i>
                Front ID
            </button>
        <?php endif; ?>
        
        <?php if($user->back_id): ?>
            <button type="button"
                    onclick="openImageModal('<?php echo e(asset('public/' . $user->back_id)); ?>')"
                    class="text-sm text-blue-600 hover:text-blue-800 flex items-center">
                <i class="ri-image-line mr-1"></i>
                Back ID
            </button>
        <?php endif; ?>
        
        <?php if($user->proof_of_residence): ?>
            <button type="button"
                    onclick="openImageModal('<?php echo e(asset('public/' . $user->proof_of_residence)); ?>')"
                    class="text-sm text-blue-600 hover:text-blue-800 flex items-center">
                <i class="ri-image-line mr-1"></i>
                Proof of Residence
            </button>
        <?php endif; ?>
    </div>
</td>
                            <td class="px-4 py-3">
                                <span class="px-2 py-1 text-xs rounded-full
                                    <?php if($user->kyc_status === 'approved'): ?> bg-green-100 text-green-800
                                    <?php elseif($user->kyc_status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                    <?php elseif($user->kyc_status === 'rejected'): ?> bg-red-100 text-red-800
                                    <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                    <?php echo e(ucfirst($user->kyc_status)); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                <?php echo e($user->updated_at->format('M d, Y H:i')); ?>

                            </td>
                            <td class="px-4 py-3">
                                <?php if($user->kyc_status === 'pending'): ?>
                                    <div class="flex space-x-2">
                                        
                                        <form action="<?php echo e(route('admin.kyc.update', $user)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <input type="hidden" name="status" value="approved">
                                            <button type="submit" 
                                                    class="px-3 py-1 text-xs text-white bg-green-600 rounded-lg hover:bg-green-700">
                                                Approve
                                            </button>
                                        </form>

                                        
                                        <button type="button"
                                                onclick="openRejectModal('<?php echo e($user->id); ?>')"
                                                class="px-3 py-1 text-xs text-white bg-red-600 rounded-lg hover:bg-red-700">
                                            Reject
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-8 text-center text-gray-500">
                                No KYC submissions found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        
        <div class="px-4 py-3 border-t">
            <?php echo e($users->links()); ?>

        </div>
    </div>

    
   <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg w-11/12 md:w-3/4 lg:w-2/3 xl:max-w-4xl">
            <div class="flex justify-between items-center p-4 border-b">
                <h3 class="text-lg font-medium">Document Preview</h3>
                <button onclick="closeImageModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="ri-close-line text-xl"></i>
                </button>
            </div>
            <div class="p-4 max-h-[calc(100vh-12rem)] overflow-auto">
                <img id="previewImage" src="" alt="Document Preview" class="max-w-full h-auto mx-auto">
            </div>
        </div>
    </div>
</div>

    
    <div id="rejectModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-lg max-w-md w-full">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Reject KYC Submission</h3>
                    <form id="rejectForm" action="" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <input type="hidden" name="status" value="rejected">
                        
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Rejection Reason
                            </label>
                            <textarea name="rejection_reason" 
                                      required
                                      rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                                      placeholder="Please provide a reason for rejection..."></textarea>
                        </div>

                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="closeRejectModal()"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                                Cancel
                            </button>
                            <button type="submit"
                                    class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700">
                                Reject
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Image Modal Functions
        function openImageModal(imageUrl) {
            document.getElementById('previewImage').src = imageUrl;
            document.getElementById('imageModal').classList.remove('hidden');
        }

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
        }

        // Reject Modal Functions
        function openRejectModal(submissionId) {
            const form = document.getElementById('rejectForm');
            form.action = `/admin/kyc/${submissionId}`;
            document.getElementById('rejectModal').classList.remove('hidden');
        }

        function closeRejectModal() {
            document.getElementById('rejectModal').classList.add('hidden');
        }

        // Status Filter
        document.getElementById('status-filter').addEventListener('change', function() {
            const status = this.value;
            const currentUrl = new URL(window.location.href);
            if (status) {
                currentUrl.searchParams.set('status', status);
            } else {
                currentUrl.searchParams.delete('status');
            }
            window.location.href = currentUrl.toString();
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?><?php /**PATH C:\Users\Digi\Downloads\Laravel Deployment Task_ Validate, Preview, and Package ZIP\aurumsafe\fsfcore\resources\views\admin\kyc\index.blade.php ENDPATH**/ ?>