<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="max-w-3xl mx-auto min-h-screen bg-white text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300 flex flex-col">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-800">
            <a href="<?php echo e(route('send.payid.details', ['symbol' => $symbol, 'network' => $network])); ?>" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Transaction Failed</h1>
            <div class="w-8"></div>
        </div>

        <!-- Main Content -->
        <div class="flex-grow flex flex-col items-center justify-center p-4 space-y-6">
            <!-- Error Icon -->
            <div class="w-24 h-24 bg-red-500 rounded-full flex items-center justify-center">
                <i class="fas fa-exclamation-triangle text-4xl text-white"></i>
            </div>

            <!-- Error Message -->
            <h2 class="text-2xl font-bold text-center">Transaction Failed</h2>
            <p class="text-gray-400 text-center"><?php echo e($error); ?></p>

            <!-- Error Details -->
            <div class="w-full max-w-md bg-gray-800 rounded-lg p-6 space-y-4">
                <?php if($error_code): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Error Code</span>
                        <span class="font-semibold"><?php echo e($error_code); ?></span>
                    </div>
                <?php endif; ?>

                <?php if($amount): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Attempted Amount</span>
                        <span class="font-semibold"><?php echo e(rtrim(sprintf('%.8f', $amount), '0')); ?> <?php echo e(strtoupper($symbol)); ?></span>
                    </div>
                <?php endif; ?>

                <?php if(isset($available_balance)): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Available Balance</span>
                        <span class="font-semibold"><?php echo e(rtrim(sprintf('%.8f', $available_balance), '0')); ?> <?php echo e(strtoupper($symbol)); ?></span>
                    </div>
                <?php endif; ?>

                <?php if($network !== 'native'): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Network</span>
                        <span class="font-semibold"><?php echo e(strtoupper($network)); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Error Description -->
            <div class="w-full max-w-md bg-red-900 bg-opacity-20 border border-red-500 rounded-lg p-4">
                <p class="text-red-500 text-sm">
                    <?php switch($error_code):
                        case ('SELF_TRANSFER'): ?>
                            You cannot send funds to your own PayID. Please use a different recipient's PayID.
                            <?php break; ?>

                        <?php case ('INSUFFICIENT_FUNDS'): ?>
                            The transaction could not be completed due to insufficient funds in your wallet. Please ensure you have enough balance to cover the transaction amount.
                            <?php break; ?>

                        <?php case ('RECIPIENT_NOT_FOUND'): ?>
                            The recipient PayID could not be found. Please check the PayID and try again.
                            <?php break; ?>

                        <?php case ('TRANSACTION_FAILED'): ?>
                            Your transaction could not be processed at this time. Please try again later.
                            <?php break; ?>

                        <?php default: ?>
                            An unexpected error occurred while processing your transaction. Please try again or contact support if the problem persists.
                    <?php endswitch; ?>
                </p>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="p-4 space-y-4">
            <a href="<?php echo e(route('send.payid.details', ['symbol' => $symbol, 'network' => $network])); ?>" 
               class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors text-center block">
                Try Again
            </a>
            <a href="<?php echo e(route('dashboard')); ?>" 
               class="w-full bg-transparent border border-gray-600 hover:bg-gray-800 text-white font-semibold py-3 px-4 rounded-lg transition-colors text-center block">
                Go to Dashboard
            </a>
        </div>
    </main>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH C:\Users\Digi\Downloads\Laravel Deployment Task_ Validate, Preview, and Package ZIP\aurumsafe\fsfcore\resources\views\user\send\payid-failed.blade.php ENDPATH**/ ?>