<x-user-layout :title="'Settings'">
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <button class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </button>
            <h1 class="text-xl font-semibold text-center flex-1">Settings</h1>
            <div class="w-8"></div>
        </div>
    
        <!-- Main Settings -->
        <div class="space-y-0">
            <a href="{{ route('crypto.manage') }}" class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                <i class="fas fa-layer-group mr-3 text-gray-600 dark:text-gray-400"></i>
                <span>Manage Crypto</span>
            </a>
            <a href="{{ route('crypto.address') }}" class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                <i class="fas fa-asterisk mr-3 text-gray-600 dark:text-gray-400"></i>
                <span>Crypto Address</span>
            </a>
            <a href="{{ route('referral.index') }}" class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                <i class="fas fa-users mr-3 text-gray-600 dark:text-gray-400"></i>
                <span>Referrals</span>
            </a>
            <a href="{{ route('notifications') }}" class="relative flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                <i class="fas fa-bell mr-3 text-gray-600 dark:text-gray-400"></i>
                <span>Notification</span>
                <span id="settings-notification-badge" class="absolute top-5 right-11 bg-red-500 text-white text-xs rounded-full w-4 h-4 flex items-center justify-center hidden">
                    0
                </span>
            </a>
        </div>
    
        <!-- Security Section -->
        <div class="mt-8">
            <h2 class="text-yellow-500 font-semibold text-lg text-center mb-4">Security</h2>
            <div class="space-y-0">
                <a href="{{ route('kyc') }}" class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                    <i class="fas fa-user-check mr-3 text-gray-600 dark:text-gray-400"></i>
                    <span>Account verification</span>
                </a>
                <a href="{{ route('profile.edit') }}" class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700">
                    <i class="fas fa-lock mr-3 text-gray-600 dark:text-gray-400"></i>
                    <span>Password settings</span>
                </a>
            </div>
        </div>
    
        <!-- Logout Button -->
        <div class="mt-8">
            <form method="POST" action="{{ route('logout') }}" class="w-full">
                @csrf
                <button class="flex items-center w-full p-4 hover:bg-gray-50 dark:hover:bg-dark-800 border-b border-gray-700 text-red-500">
                    <i class="fas fa-power-off mr-3"></i>
                    <span>Logout</span>
                </button>
            </form>
        </div>
    </main>
</x-user-layout>
<script>
document.addEventListener('DOMContentLoaded', function() {
    function updateSettingsNotificationBadge() {
        fetch('/notifications/unread-count')
            .then(response => response.json())
            .then(data => {
                const badge = document.getElementById('settings-notification-badge');
                if (data.count > 0) {
                    badge.textContent = data.count > 9 ? '9+' : data.count;
                    badge.classList.remove('hidden');
                } else {
                    badge.classList.add('hidden');
                }
            })
            .catch(error => console.error('Error fetching notification count:', error));
    }

    // Initial load
    updateSettingsNotificationBadge();

    // Periodic updates every 5 minutes
    setInterval(updateSettingsNotificationBadge, 5 * 60 * 1000);
});
</script>