<x-user-layout>
    <main class="w-full mx-auto h-auto bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <button wire:navigate href="{{ route('receive.external') }}" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </button>
            <h1 class="text-xl font-semibold">Receive {{ $asset['name'] }}</h1>
            <div class="w-8"></div>
        </div>

        <!-- Main Content -->
        <div class="p-4 space-y-6">
            <!-- Warning Banner -->
            <div class="bg-yellow-900/20 border border-yellow-500/20 rounded-lg p-4">
                <div class="flex items-center space-x-2">
                    <i class="fas fa-exclamation-circle text-gray-800 dark:text-yellow-500"></i>
                    <p class="text-gray-800 dark:text-yellow-500 text-sm">
                        Only send {{ $asset['name'] }}{{ $asset['network'] ? ' (' . $asset['network'] . ')' : '' }} assets to this address. Other assets will be lost forever.
                    </p>
                </div>
            </div>

            <!-- Wallet Info -->
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="relative">
                        @if($asset['icon_url'])
                            <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-10 h-10 rounded-full">
                            @if(!empty($asset['network_url']))
                                <img src="{{ $asset['network_url'] }}" 
                                    alt="{{ $asset['network'] }}" 
                                    class="absolute border border-white dark:border-gray-800" 
                                    style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                            @endif
                        @endif
                    </div>
                    <div>
                        <div class="flex items-center space-x-2">
                            <span class="font-semibold">{{ $asset['symbol'] }}</span>
                            @if($asset['network'])
                                <span class="text-xs bg-white dark:bg-gray-800 px-2 py-0.5 rounded">{{ $asset['network'] }}</span>
                            @endif
                        </div>
                        <span class="text-sm text-gray-600 dark:text-gray-400">{{ $asset['name'] }}</span>
                    </div>
                </div>
                <div class="text-right">
                    <div class="font-semibold">{{ number_format($asset['balance'], 8) }} {{ $asset['symbol'] }}</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400">${{ number_format($asset['value'], 2) }}</div>
                </div>
            </div>

            <!-- QR Code Container -->
            <div class="flex flex-col items-center space-y-4">
                <div class="bg-white dark:bg-gray-800 p-6 rounded-lg">
                    <div id="qrcode" class="w-64 h-64 relative">
                        <!-- QR Code will be generated here -->
                    </div>
                </div>
                <!-- Wallet Address -->
                <p class="text-sm font-mono text-gray-800 dark:text-gray-400 select-all break-all px-4 text-center" id="walletAddress">{{ $asset['address'] }}</p>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-center space-x-12">
                <!-- Copy Button -->
                <button onclick="copyAddress()" class="flex flex-col items-center space-y-2 text-gray-700 dark:text-gray-400 hover:text-gray-300">
                    <div class="w-12 h-12 bg-white dark:bg-gray-800 rounded-full flex items-center justify-center">
                        <i class="far fa-copy text-xl"></i>
                    </div>
                    <span class="text-sm">Copy</span>
                </button>

                <!-- Share Button -->
                <button onclick="shareAddress()" class="flex flex-col items-center space-y-2 text-gray-700 dark:text-gray-400 hover:text-gray-300">
                    <div class="w-12 h-12 bg-white dark:bg-gray-800 rounded-full flex items-center justify-center">
                        <i class="fab fa-whatsapp text-xl"></i>
                    </div>
                    <span class="text-sm">Share</span>
                </button>
            </div>

            <!-- Deposit from Exchange -->
            <button class="w-full mt-6 bg-white dark:bg-black/50 hover:bg-gray-50 dark:hover:bg-black rounded-lg p-4">
                <a href="{{ route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-yellow-500 text-left font-medium">Deposit from exchange</p>
                        <p class="text-sm text-gray-700 dark:text-gray-400 text-left">By direct transfer from your account</p>
                    </div>
                    <i class="fas fa-arrow-down text-gray-600 dark:text-gray-400"></i>
                </div>
                </a>
            </button>

            <!-- Copy Success Message -->
            <div id="copyMessage" class="fixed top-20 right-4 bg-green-500 text-white px-4 py-2 rounded-lg transform translate-y-[-100%] opacity-0 transition-all duration-300">
                Address copied to clipboard
            </div>
        </div>
    </main>

    @push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const qrContainer = document.getElementById('qrcode');
            // Clear any existing content
            qrContainer.innerHTML = '';
            
            // Generate QR Code
            new QRCode(qrContainer, {
                text: '{{ $asset['address'] }}',
                width: 256,
                height: 256,
                colorDark: document.querySelector('html').classList.contains('dark') ? "#FFFFFF" : "#000000",
                colorLight: document.querySelector('html').classList.contains('dark') ? "#1F2937" : "#FFFFFF",
                correctLevel: QRCode.CorrectLevel.H
            });

            // Add logo overlay
            const logoDiv = document.createElement('div');
            logoDiv.className = 'absolute inset-0 flex items-center justify-center pointer-events-none';
            logoDiv.innerHTML = `
                <div class="w-12 h-12 bg-white rounded-full flex items-center justify-center">
                    <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-8 h-8 rounded-full">
                </div>
            `;
            qrContainer.appendChild(logoDiv);
        });

        // Copy functionality
        function copyAddress() {
            const address = document.getElementById('walletAddress').textContent;
            navigator.clipboard.writeText(address)
                .then(() => {
                    // Show success message
                    const message = document.getElementById('copyMessage');
                    message.style.transform = 'translate(0, 0)';
                    message.style.opacity = '1';
                    
                    // Hide after 2 seconds
                    setTimeout(() => {
                        message.style.transform = 'translate(0, -100%)';
                        message.style.opacity = '0';
                    }, 2000);
                })
                .catch(err => {
                    console.error('Failed to copy text: ', err);
                });
        }

        // Share functionality
        function shareAddress() {
            const address = document.getElementById('walletAddress').textContent;
            const shareText = `${address}`;
            const shareUrl = `https://wa.me/?text=${encodeURIComponent(shareText)}`;
            window.open(shareUrl, '_blank');
        }
    </script>
    @endpush
</x-user-layout>