
## Implemented BIPs

This page lists BIPs implemented by the core library.
 
Some BIPs are specific to the network layer - for these see [Bitcoin P2P](https://github.com/Bit-Wasp/bitcoin-p2p-php)

  - [BIP 11](https://github.com/bitcoin/bips/blob/master/bip-0011.mediawiki) - M of N standard transactions
  - [BIP 13](https://github.com/bitcoin/bips/blob/master/bip-0013.mediawiki) - Pay to Script Hash address format
  - [BIP 14](https://github.com/bitcoin/bips/blob/master/bip-0014.mediawiki) - Protocol Version and User Agent
  - [BIP 16](https://github.com/bitcoin/bips/blob/master/bip-0016.mediawiki) - Pay to Script Hash
  - [BIP 21](https://github.com/bitcoin/bips/blob/master/bip-0021.mediawiki) - Bitcoin URI's
  - [BIP 32](https://github.com/bitcoin/bips/blob/master/bip-0032.mediawiki) - Hierarchical Deterministic Wallets
  - [BIP 37](https://github.com/bitcoin/bips/blob/master/bip-0037.mediawiki) - Bloom Filtering
  - [BIP 39](https://github.com/bitcoin/bips/blob/master/bip-0039.mediawiki) - Mnemonic code for generating deterministic keys
  - [BIP 65](https://github.com/bitcoin/bips/blob/master/bip-0065.mediawiki) - OP_CHECKLOCKTIMEVERIFY
  - [BIP 66](https://github.com/bitcoin/bips/blob/master/bip-0066.mediawiki) - Strict DER Signatures
  - [BIP 67](https://github.com/bitcoin/bips/blob/master/bip-0067.mediawiki) - Deterministic P2SH multi-signature addresses
  - [BIP 69](https://github.com/bitcoin/bips/blob/master/bip-0069.mediawiki) - Lexicographical Indexing of Transaction Inputs and Outputs
  - [BIP 112](https://github.com/bitcoin/bips/blob/master/bip-0112.mediawiki) - OP_CHECKSEQUENCEVERIFY
  - [BIP 141](https://github.com/bitcoin/bips/blob/master/bip-0141.mediawiki) - Segregated Witness (Consensus layer)
  - [BIP 143](https://github.com/bitcoin/bips/blob/master/bip-0143.mediawiki) - Transaction Signature Verification for Version 0 Witness Program
  - [BIP 146](https://github.com/bitcoin/bips/blob/master/bip-0146.mediawiki) - Dealing with signature encoding malleability
  - [BIP 147](https://github.com/bitcoin/bips/blob/master/bip-0147.mediawiki) - Dealing with dummy stack element malleability
  - [BIP 173](https://github.com/bitcoin/bips/blob/master/bip-0173.mediawiki) - Bech32 and segwit address encoding
