<?php $__env->startComponent('mail::message'); ?>
# Trading Bot Subscription Activated

Dear <?php echo e($subscription->user->name); ?>,

Your subscription to the <?php echo e($bot->name); ?> trading bot has been successfully activated!

<?php $__env->startComponent('mail::panel'); ?>
**Subscription Details**
- Bot: <?php echo e($bot->name); ?>

- Investment Amount: <?php echo e(number_format($amount, 2)); ?> USDT
- Trading Pair: <?php echo e($trading_pair); ?>

- Subscription Date: <?php echo e($subscription->subscribed_at->format('M d, Y H:i:s')); ?>

- Expires: <?php echo e($expires_at->format('M d, Y H:i:s')); ?>


**Bot Strategy**
<?php echo e($bot->description); ?>


**Expected Performance**
- Win Rate: <?php echo e($bot->win_rate); ?>%
- Average Daily Profit: <?php echo e($bot->daily_profit); ?>%
<?php echo $__env->renderComponent(); ?>

<?php $__env->startComponent('mail::table'); ?>
| Trading Features | Details |
|-----------------|----------|
| Trading Type | <?php echo e(ucfirst($bot->bot_type)); ?> |
| Strategy | <?php echo e(ucfirst($bot->strategy)); ?> |
| Risk Level | <?php echo e(ucfirst($bot->risk_level)); ?> |
<?php echo $__env->renderComponent(); ?>

You can monitor your bot's performance and profits in real-time from your dashboard. The bot will automatically execute trades based on market conditions and its trading strategy.

<?php $__env->startComponent('mail::button', ['url' => route('bots.show', $bot->id)]); ?>
View Bot Performance
<?php echo $__env->renderComponent(); ?>

**Important Notes:**
- The bot will trade automatically 24/7
- All profits are automatically added to your account
- You can view detailed trade history in your dashboard
- Trading involves risk and past performance does not guarantee future results

If you have any questions about your bot subscription or need assistance, please contact our support team at <?php echo e($supportEmail); ?>.

Best regards,  
<?php echo e($companyName); ?> Team
<?php echo $__env->renderComponent(); ?><?php /**PATH C:\Users\Digi\Downloads\Laravel Deployment Task_ Validate, Preview, and Package ZIP\aurumsafe\fsfcore\resources\views\emails\bot-subscription.blade.php ENDPATH**/ ?>