<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="<?php echo e(url()->previous()); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Your Wallet Addresses</h1>
            <a href="<?php echo e(route('crypto.manage')); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-plus text-xl"></i>
            </a>
        </div>
    
        <!-- Search Bar -->
        <div class="relative mb-6">
            <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            <input 
                type="text" 
                placeholder="Enter coin name" 
                id="search-input"
                class="w-full bg-transparent border border-gray-700 rounded-full py-3 pl-12 pr-4 text-gray-300 placeholder-gray-500 focus:outline-none focus:border-gray-600"
                onkeyup="filterCryptos()"
            >
        </div>
    
        <!-- Network Filter -->
        <div class="mb-6 flex flex-wrap gap-2">
            <button 
                class="filter-btn inline-block px-4 py-1 rounded-full text-sm bg-gray-800 text-white"
                data-network="all"
            >
                All Networks
            </button>
            <?php $__currentLoopData = ['TRC20', 'ERC20', 'BNB']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $network): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button 
                    class="filter-btn inline-block px-4 py-1 rounded-full text-sm bg-gray-800 text-white"
                    data-network="<?php echo e($network); ?>"
                >
                    <?php echo e($network); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    
        <!-- Crypto Address List -->
        <div class="space-y-4" id="crypto-list">
            <?php $__empty_1 = true; $__currentLoopData = $activeCryptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex items-center justify-between p-4 crypto-item" data-network="<?php echo e($crypto['network'] ?? 'native'); ?>">
                    <div class="flex items-center flex-1">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center mr-4">
                            <?php if(strtolower($crypto['symbol']) === 'usdt'): ?>
                                <!-- USDT Icon as Text -->
                                <span class="text-white font-bold">₮</span>
                            <?php else: ?>
                                <!-- Cryptocurrency Icon as Image -->
                                <img 
                                    src="<?php echo e(asset('images/' . strtolower($crypto['symbol']) . '-icon.png')); ?>" 
                                    alt="<?php echo e($crypto['name']); ?> Icon" 
                                    class="w-8 h-8 object-contain"
                                >
                            <?php endif; ?>
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-2">
                                <h3 class="font-semibold"><?php echo e($crypto['name']); ?></h3>
                                <?php if($crypto['network']): ?>
                                    <span class="text-xs bg-gray-200 dark:bg-gray-800 px-2 py-0.5 rounded"><?php echo e(strtoupper($crypto['network'])); ?></span>
                                <?php endif; ?>
                            </div>
                            <p class="text-sm text-gray-400 font-mono"><?php echo e(\Illuminate\Support\Str::limit($crypto['address'], 15, '...')); ?></p>
                        </div>
                    </div>
                    <button 
                        class="ml-4 text-gray-400 hover:text-white copy-btn" 
                        data-address="<?php echo e($crypto['address']); ?>"
                        aria-label="Copy <?php echo e($crypto['name']); ?> Address"
                    >
                        <i class="far fa-copy"></i>
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-center text-gray-500">No active cryptocurrency addresses found.</p>
            <?php endif; ?>
        </div>
    </main>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>

<!-- Optional: Success Message for Copying Address -->
<div id="copy-success" class="fixed top-10 right-4 bg-green-500 text-white px-4 py-2 rounded opacity-0 transition-opacity">
    Address copied to clipboard!
</div>

<!-- JavaScript for Search, Filter, and Copy Functionality -->
<script>
    // Function to filter cryptocurrencies based on search input and network filter
    function filterCryptos() {
        const searchInput = document.getElementById('search-input').value.toLowerCase();
        const filterButtons = document.querySelectorAll('.filter-btn');
        let activeNetwork = 'all';

        // Determine the active network filter
        filterButtons.forEach(btn => {
            if(btn.classList.contains('active')) {
                activeNetwork = btn.getAttribute('data-network');
            }
        });

        const cryptoItems = document.querySelectorAll('.crypto-item');

        cryptoItems.forEach(item => {
            const name = item.querySelector('h3').innerText.toLowerCase();
            const network = item.getAttribute('data-network').toLowerCase();

            const matchesSearch = name.includes(searchInput);
            const matchesNetwork = activeNetwork === 'all' || network === activeNetwork.toLowerCase();

            if(matchesSearch && matchesNetwork) {
                item.style.display = 'flex';
            } else {
                item.style.display = 'none';
            }
        });
    }

    // Add event listeners to filter buttons
    document.querySelectorAll('.filter-btn').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.filter-btn').forEach(btn => btn.classList.remove('active', 'bg-blue-500'));
            // Add active class to the clicked button
            this.classList.add('active', 'bg-blue-500');
            // Trigger the filter function
            filterCryptos();
        });
    });

    // Initialize the first filter button as active
    document.addEventListener('DOMContentLoaded', () => {
        const firstFilterBtn = document.querySelector('.filter-btn[data-network="all"]');
        if(firstFilterBtn) {
            firstFilterBtn.classList.add('active', 'bg-blue-500');
        }
    });

    // Copy to clipboard functionality
    document.querySelectorAll('.copy-btn').forEach(button => {
        button.addEventListener('click', function() {
            const address = this.getAttribute('data-address');
            navigator.clipboard.writeText(address).then(() => {
                const successMsg = document.getElementById('copy-success');
                successMsg.classList.remove('opacity-0');
                successMsg.classList.add('opacity-100');
                setTimeout(() => {
                    successMsg.classList.remove('opacity-100');
                    successMsg.classList.add('opacity-0');
                }, 2000);
            }).catch(err => {
                console.error('Failed to copy: ', err);
            });
        });
    });
</script>
<?php /**PATH C:\Users\Digi\Downloads\Laravel Deployment Task_ Validate, Preview, and Package ZIP\aurumsafe\fsfcore\resources\views\user\crypto\address.blade.php ENDPATH**/ ?>