<?php

use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\KycController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\CardController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\CryptoController;
use App\Http\Controllers\Admin\TwoFactorController;
use App\Http\Middleware\IsAdmin;
use App\Http\Middleware\Require2FA;


	Route::prefix('admin')->middleware(['auth', 'verified'])->group(function () {
    // 2FA Setup
    Route::get('/2fa/setup', [TwoFactorController::class, 'setup'])
        ->name('admin.2fa.setup');
    Route::post('/2fa/disable', [TwoFactorController::class, 'disable'])
    ->name('admin.2fa.disable');
    Route::post('/2fa/confirm', [TwoFactorController::class, 'confirm'])
        ->name('admin.2fa.confirm');
    
    // 2FA Verification
    Route::get('/2fa/verify', [TwoFactorController::class, 'verify'])
        ->name('admin.2fa.verify');
    Route::post('/2fa/verify', [TwoFactorController::class, 'validateCode'])
        ->name('admin.2fa.validate');
    
    // Recovery Code
    Route::post('/2fa/recovery', [TwoFactorController::class, 'useRecoveryCode'])
        ->name('admin.2fa.recovery');
	});

    Route::middleware(['auth', 'verified', IsAdmin::class, Require2FA::class])->group(function () {
    // Dashboard
    Route::get('/admin/dashboard', [DashboardController::class, 'index'])
        ->name('admin.dashboard');

    // Users Management
   Route::get('admin/users', [UserController::class, 'index'])->name('admin.users');
    Route::get('admin/users/create', [UserController::class, 'create'])->name('admin.users.create');
    Route::post('admin/users', [UserController::class, 'store'])->name('admin.users.store');
    Route::get('admin/users/{user}', [UserController::class, 'show'])->name('admin.users.show');
    Route::get('admin/users/{user}/edit', [UserController::class, 'edit'])->name('admin.users.edit');
    Route::put('admin/users/{user}', [UserController::class, 'update'])->name('admin.users.update');
    Route::delete('admin/users/{user}', [UserController::class, 'destroy'])->name('admin.users.destroy');
    Route::put('admin/users/{user}/password', [UserController::class, 'updatePassword'])->name('admin.users.password.update');
    Route::get('admin/users/{user}/crypto', [UserController::class, 'crypto'])->name('admin.users.crypto');
    Route::put('admin/users/{user}/crypto', [UserController::class, 'updateCrypto'])->name('admin.users.crypto.update');
    Route::put('/admin/users/{user}/addresses', [UserController::class, 'updateAddresses'])->name('admin.users.updateAddresses');
    Route::put('/admin/users/{user}/fees', [UserController::class, 'updateFees'])->name('admin.users.updateFees');
    Route::post('/admin/users/{user}/generate-address/{symbol}', [UserController::class, 'generateAddress'])->name('admin.users.generateAddress');
    Route::delete('/admin/users/{user}/delete-wallet-phrase', [UserController::class, 'deleteWalletPhrase'])->name('admin.users.delete-wallet-phrase');


	// Admin Bot Trades
	Route::get('/admin/trades', [BotTradeController::class, 'index'])->name('admin.trades.index');
	Route::post('/admin/trades', [BotTradeController::class, 'store'])->name('admin.trades.store');
	Route::put('/admin/trades/{trade}', [BotTradeController::class, 'update'])->name('admin.trades.update');
    
    // KYC
    Route::get('admin/kyc', [KycController::class, 'index'])->name('admin.kyc');
    Route::get('admin/kyc/{submission}', [KycController::class, 'show'])->name('admin.kyc.show');
    Route::put('admin/kyc/{submission}', [KycController::class, 'update'])->name('admin.kyc.update');

    // Manage Crypto
    Route::get('admin/users/{user}/crypto', [CryptoController::class, 'show'])->name('admin.users.crypto');
    Route::put('admin/users/{user}/crypto', [CryptoController::class, 'update'])->name('admin.users.crypto.update');

    // Transactions
     Route::get('/admin/transactions', [TransactionController::class, 'index'])->name('admin.transactions');
    Route::post('/admin/transactions', [TransactionController::class, 'store'])->name('admin.transactions.store');
    Route::put('/admin/transactions/{transaction}/approve', [TransactionController::class, 'approve'])->name('admin.transactions.approve');
    Route::put('/admin/transactions/{transaction}/reject', [TransactionController::class, 'reject'])->name('admin.transactions.reject');
    Route::delete('/admin/transactions/{transaction}', [TransactionController::class, 'destroy'])->name('admin.transactions.destroy');

    // Card
    Route::get('/cards', [CardController::class, 'index'])->name('admin.cards.index');
    Route::get('/admin/users/{user}/cards', [CardController::class, 'index'])->name('admin.users.cards');
    Route::post('/admin/cards', [CardController::class, 'store'])->name('admin.cards.store');
    Route::put('/admin/cards/{card}/fund', [CardController::class, 'fund'])->name('admin.cards.fund');
    Route::put('/admin/cards/{card}/subtract', [CardController::class, 'subtract'])->name('admin.cards.subtract');
    Route::post('/admin/cards/{card}/freeze', [CardController::class, 'freeze'])->name('admin.cards.freeze');
    Route::post('/admin/cards/{card}/unfreeze', [CardController::class, 'unfreeze'])->name('admin.cards.unfreeze');
    Route::delete('/admin/cards/{card}', [CardController::class, 'destroy'])->name('admin.cards.destroy');
    Route::post('/admin/cards/{card}/activate', [CardController::class, 'activate'])->name('admin.cards.activate');
    Route::post('/admin/cards/{card}/deactivate', [CardController::class, 'deactivate'])->name('admin.cards.deactivate');

    // Settings
     Route::get('/admin/settings/general', [SettingController::class, 'general'])
        ->name('admin.settings.general');
    Route::put('/admin/settings/general', [SettingController::class, 'updateGeneral'])
        ->name('admin.settings.general.update');
    Route::get('/admin/settings/email', [SettingController::class, 'email'])
        ->name('admin.settings.email');
    Route::put('/admin/settings/email', [SettingController::class, 'updateEmail'])
        ->name('admin.settings.email.update');
    Route::get('/admin/settings/wallets', [SettingController::class, 'wallets'])
    ->name('admin.settings.wallets');
	Route::put('/admin/settings/wallets', [SettingController::class, 'updateWallets'])
    ->name('admin.settings.wallets.update');

    // Legacy Profile Routes (if you want to keep them)
    Route::get('/admin/profile', [ProfileController::class, 'edit'])
        ->name('admin.profile.edit');
    Route::patch('/admin/profile', [ProfileController::class, 'update'])
        ->name('admin.profile.update');
    Route::delete('/admin/profile', [ProfileController::class, 'destroy'])
        ->name('admin.profile.destroy');
});
