<x-user-layout>
    <div class="w-full mx-auto min-h-screen bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <button wire:navigate href="{{ route('dashboard') }}" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </button>
            <h1 class="text-xl font-semibold">Buy Crypto</h1>
            <div class="w-8"><!-- Empty div for alignment --></div>
        </div>

        <!-- Search and Filter -->
        <div class="p-4 space-y-4">
            <!-- Search Bar -->
            <div class="relative">
                <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-500"></i>
                <input 
                    type="text" 
                    placeholder="Enter coin name" 
                    class="w-full bg-transparent border border-gray-700 rounded-full py-2 pl-12 pr-4 text-white placeholder-gray-500 focus:outline-none focus:border-gray-600"
                >
            </div>

            <!-- Network Filter -->
            <div>
                <span class="inline-block px-4 py-1 rounded-full text-sm bg-gray-100 border border-gray-800 dark:bg-gray-800 text-gray:800 dark:text-white">
                    All Networks
                </span>
            </div>
        </div>

        <!-- Crypto List -->
        <div class="space-y-4 p-4">
            @foreach($assets as $asset)
                <a href="{{ route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                   class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="relative">
                            @if($asset['icon_url'])
                                <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-10 h-10 rounded-full">
                                @if(!empty($asset['network_url']))
                                    <img src="{{ $asset['network_url'] }}" 
                                         alt="{{ $asset['network'] }}" 
                                         class="absolute border border-light" 
                                         style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                                @endif
                            @else
                                <div class="w-10 h-10 bg-gray-500 rounded-full flex items-center justify-center">
                                    <span class="text-white font-bold">{{ $asset['symbol'] }}</span>
                                </div>
                            @endif
                        </div>
                        <div class="ml-3">
                            <div class="flex items-center">
                                <span class="font-semibold mr-2">{{ $asset['symbol'] }}</span>
                                @if($asset['network'])
                                    <span class="text-xs bg-white dark:bg-gray-800 px-2 py-0.5 rounded">{{ $asset['network'] }}</span>
                                @endif
                            </div>
                            <div class="flex items-center text-sm">
                                <span class="text-gray-400 mr-2">${{ number_format($asset['price'], 2) }}</span>
                                <span class="@if(str_starts_with($asset['change'], '-')) text-red-500 @else text-green-500 @endif">
                                    {{ $asset['change'] }}%
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold">{{ number_format($asset['balance'], 4) }}</div>
                        <div class="text-sm text-gray-400">${{ number_format($asset['value'], 2) }}</div>
                    </div>
                </a>
            @endforeach
        </div>
    </div>
</x-user-layout>