@component('mail::message')
@if($type === 'submission')
# KYC Documents Received

Dear {{ $user->name }},

We have received your KYC (Know Your Customer) documents for verification. Thank you for submitting the required documentation.

@component('mail::panel')
**Documents Received**
@foreach($documents as $doc => $path)
- {{ ucwords(str_replace('_', ' ', $doc)) }}
@endforeach

**Submission Date:** {{ now()->format('M d, Y H:i:s') }}
@endcomponent

Our compliance team will review your documents within 24-48 hours. You will receive another email once the verification process is complete.

**Important Notes:**
- Please ensure all documents are clear and legible
- Documents must be valid and not expired
- All information should match your account details

@else
# KYC Verification {{ ucfirst($status) }}

Dear {{ $user->name }},

@if($status === 'approved')
Your KYC verification has been successfully completed and approved. Your account now has full access to all features.

@component('mail::panel')
**Account Status:** Fully Verified
**Verification Date:** {{ now()->format('M d, Y H:i:s') }}

Your account now has access to:
- Unlimited crypto sending and receiving
- Full trading features and limits
- Complete platform functionality
- Referral bonus eligibility
@endcomponent

@elseif($status === 'rejected')
Your KYC verification requires updates. Our compliance team has reviewed your submission and needs additional information.

@component('mail::panel')
**Verification Status:** Update Required
**Review Date:** {{ now()->format('M d, Y H:i:s') }}

**Reason for Update Request:**
{{ $rejectionReason ?? 'One or more submitted documents did not meet our verification requirements.' }}

**Common Requirements:**
- Documents must be clear and fully visible
- All text should be legible
- Documents should be current and valid
- Information must match your account details
@endcomponent

Please submit updated documents through your KYC verification page. Ensure your new submission addresses the feedback provided above.

@else
Your KYC verification status has been updated to: {{ ucfirst($status) }}
@endif
@endif

@component('mail::button', ['url' => route('kyc')])
View KYC Status
@endcomponent

If you need assistance or have questions about the verification process, our support team is here to help at {{ $supportEmail }}.

Best regards,  
{{ $companyName }} Team
@endcomponent