<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Google2FA extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'secret',
        'enabled',
        'backup_codes'
    ];

    protected $casts = [
        'enabled' => 'boolean',
        'backup_codes' => 'array'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
