<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;

    /**
     * Create a new message instance.
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Welcome to ' . setting('company_name', config('app.name')))
                    ->markdown('emails.welcome')
                    ->with([
                        'name' => $this->user->name,
                        'email' => $this->user->email,
                        'uuid' => $this->user->uuid,
                        'companyName' => setting('company_name', config('app.name')),
                        'dashboardUrl' => route('dashboard'),
                        'supportEmail' => setting('company_email', 'support@example.com')
                    ]);
    }
}